<?LassoScript
// Prepared for Lasso Summit 2006
// by Eric Landmann, Landmann InterActive, elandmann@landmanninteractive.com

// DEVEL NOTES
// This file does the heavy lifting
// It processes the uploaded image, creates image files, and makes a database entry

Include:'siteconfig.lasso';

// Setting variables
Var:'vProcess' = string;
Var:'vError' = string;
Var:'vOption' = string;

Var:'vProcess'=(Action_Param:'Process');
Var:'vError'=(Action_Param:'Error');
Var:'vOption'=(Action_Param:'Option');

Var:'vArea'=(Action_Param:'Area');
Var:'vCrag'=(Action_Param:'Crag');
Var:'vRouteID'=(Action_Param:'RouteID');
Var:'vImageTitle'=(Action_Param:'ImageTitle');
Var:'vCaption'=(Action_Param:'Caption');
Var:'vImageCredits'=(Action_Param:'ImageCredits');


// If: $vProcess == 'Y';

	// Convert action_params
	If: (Action_Param:'Area') != '';
		Var:'vArea'=(Action_Param:'Area');
	/If;
	If: (Action_Param:'Crag') != '';
		Var:'vCrag'=(Action_Param:'Crag');
	/If;
	If: (Action_Param:'RouteID') != '';
		Var:'vRouteID'=(Action_Param:'RouteID');
	/If;
	If: (Action_Param:'ImageTitle') != '';
		Var:'vImageTitle'=(Action_Param:'ImageTitle');
	/If;
	If: (Action_Param:'Caption') != '';
		Var:'vCaption'=(Action_Param:'Caption');
	/If;
	If: (Action_Param:'ImageCredits') != '';
		Var:'vImageCredits'=(Action_Param:'ImageCredits');
	/If;
	If: (Action_Param:'Process') != '';
		Var:'vProcess'=(Action_Param:'Process');
	/If;
// /If;
// Include header
Include: ($svMastheadPath) 'header.inc';

// If form not submit, do the popup menus to select area, crag and route
// If: $vProcess != 'Y';

	If: (Var:'vError') != '';
		Show_Error: -ErrNum=(Var:'vError'), -Option=(Var:'vOption'), -PosColor='00CC00', -NegColor='FF0000', -BgColor='CCCCCC';
	/If;

// If form not submit, do the popup menus to select area, crag and route
// If: $vProcess != 'Y';
If: $vProcess != 'Y';
?>
	<form enctype="multipart/form-data" action="[Response_Filepath]" method="post">
		<table border="0" cellpadding="2" cellspacing="2" width="460">
			<tr>
				<td VALIGN="top"></td>
			</tr>
			<tr> 
				<td colspan="2"><h2>Upload Images</h2></td>
			</tr>
	<?Lassoscript
	// STEP 1: Select an Area
		'\t<tr>\r';
		'\t\t<td valign="top">\r';
			'\t\t\t<b>Area</b>\r';
		'\t\t</td>\r';
		Var:'SQLSearchAreas' = 'SELECT DISTINCT Crag_Area FROM ' $svCategoryTable ' ORDER BY Crag_Area';
		Inline: -Search, 
			-Database=$svDatabase, 												
			-Table=$svCategoryTable,
			-Username=$svUsername,
			-Password=$svPassword,
			-SQL=$SQLSearchAreas;
			// Create Select
			'\t\t<td colspan="2" valign="top">\r';
			'\t\t\t<select name="Area" onChange="this.form.submit()">\r';
				'\t\t\t\t<option value="">=== Select an Area ===</option>\r';
				Records;
					Var:'vAreaSelect' = (Field:'Crag_Area');
					'\t\t\t\t<option value="'; (Var:'vAreaSelect'); '"'; If: (Var:'vArea')==(Var:'vAreaSelect'); 'selected'; /If; '>'; (Var:'vAreaSelect'); '</option>\r';
				/Records;
			'\t\t\t</select>\r';
		'\t\t</td>\r';
		'\t</tr>\r';
	
		/Inline;
	
	// STEP 2: We have an area, now select a crag
	If: (Var:'vArea') != '';
		'\t<tr>\r';
		'\t\t<td valign="top">\r';
			'\t\t\t<b>Crag</b>\r';
		'\t\t</td>\r';

		// Sample Query:
		// SELECT DISTINCT Crag_Crag FROM beta_Crag WHERE Crag_Active="Y" AND Crag_Area = "Southern WI"
		Var:'SQLSearchCrags' = 'SELECT DISTINCT Crag_Crag FROM ' $svCategoryTable ' WHERE Crag_Area = "'$vArea'"';
		Inline: -Search, 
			-Database=$svDatabase,
			-Table=$svCategoryTable,
			-Username=$svUsername,
			-Password=$svPassword,
			-SQL=$SQLSearchCrags;
			// Create Select
			'\t\t<td colspan="2" valign="top">\r';
			'\t\t\t<select name="Crag" onChange="this.form.submit()">\r';
				'\t\t\t\t<option value="">=== Select a Crag ===</option>\r';
				Records;
				'\t\t\t\t<option value="'; (Field:'Crag_Crag'); '"'; If: (Field:'Crag_Crag')==(Var:'vCrag'); ' selected'; /If; '>'; (Field:'Crag_Crag'); '</option>\r';
				/Records;
			'\t\t\t</select>\r';
		'\t\t</td>\r';
		'\t\t</tr>\r';
	
		/Inline;

	/If;
	
	// STEP 3: We have an area and a crag, now select a route
	If: (Var:'vCrag') != '';
		'\t<tr>\r';
		'\t\t<td valign="top">\r';
			'\t\t\t<b>Route</b>\r';
		'\t\t</td>\r';
		Var:'SQLSearchRoutes' = 'SELECT DISTINCT Route_Name,ID FROM ' $svContentTable ' WHERE  Crag="'$vCrag'" ORDER BY Route_Name';
		Inline: -Search, 
			-Database=$svDatabase, 												
			-Table=$svContentTable,
			-Username=$svUsername,
			-Password=$svPassword,
			-SQL=$SQLSearchRoutes;
			// Create Select
			'\t\t<td colspan="2" valign="top">\r';
			'\t\t\t<select name="RouteID" onChange="this.form.submit()">\r';
				'\t\t\t\t<option value="">=== Select a Route ===</option>\r';
				Records;
				'\t\t\t\t<option value="'; (Field:'ID'); '"'; If: (Field:'ID')==(Var:'vRouteID'); 'selected'; /If; '>'; (Field:'Route_Name'); '</option>\r';
				/Records;
			'\t\t\t</select>\r';
		'\t\t</td>\r';
		'\t</tr>\r';
	
		/Inline;

	/If;

	If: (Var:'vArea') != '' && (Var:'vCrag') != '' && (Var:'vRouteID') != '';
	?>
			<tr height="10"> 
				<td colspan="2" valign="top" bgcolor="#FFFFFF"><!--Spacer--></td>
			</tr>

			<tr>
				<td width="100" bgcolor="[Var:'svInputHeaderColor']"> 
					<p align="right"><b><font color="#FFFFFF">Image Title</font></b></p>
				</td>
				<td width="360" bgcolor="[Var:'svInputContentColor']">
					<p><textarea name="ImageTitle" rows="1" cols="32">[Var:'vImageTitle']</textarea></p>
				</td>
			</tr>

			<tr> 
				<td width="100" bgcolor="[Var:'svInputHeaderColor']" valign="top"> 
					<p align="right"><b><font color="#FFFFFF">Image Caption</font></b></p>
				</td>
				<td width="360" valign="top" bgcolor="[Var:'svInputContentColor']"> 
					<textarea name="Caption" rows="4" cols="32">[Var:'vCaption']</textarea>
				</td>
			</tr>

			<tr>
				<td width="100" bgcolor="[Var:'svInputHeaderColor']"> 
					<p align="right"><b><font color="#FFFFFF">Image Credits</font></b></p>
				</td>
				<td width="360" bgcolor="[Var:'svInputContentColor']">
					<p><textarea name="ImageCredits" rows="1" cols="32">[Var:'vImageCredits']</textarea></p>
				</td>
			</tr>

			<tr> 
				<td width="100" bgcolor="[Var:'svInputHeaderColor']" valign="top"> 
					<p align="right"><b><font color="#FFFFFF">Image to Upload</font></b></p>
				</td>
				<td width="360" valign="top" bgcolor="[Var:'svInputContentColor']">
					<p><input name="one" type="file"></p>
				</td>
			</tr>
			<tr>
				<td valign="top" colspan="2">
					<p align="center">
						<input type="hidden" name="Process" value="Y">
						<input type="submit" value="Upload">
					</p>
				</td>
			</tr>
		[/If]
		</table>
	</form>

<?LassoScript
// Upload form submitted, now process the image
Else;

	// Process the Upload
	Include:($svLibsPath) 'process_uploads.inc';

	// Make the database entry
	// If required missing, kick out 1001 "Required missing" error
	If: (Var:'vImageContentID')=='';
		Var:'vError'='1001';
	/If;
	
	
	// Constructing the query
	Var:'vSQLAddImage'=(string);
	Var:'vSQLAddImage'='INSERT INTO ' $svDatabase '.' $svImagesTable ' SET
		Image_ContentID = "'	(Encode_SQL: $vRouteID) '",
		Image_Name = "'			(Encode_SQL: $NewFileName) '",
		Image_Caption = "'		(Encode_SQL: (Var:'vCaption')) '",
		Image_Credits = "'		(Encode_SQL: (Var:'vImageCredits')) '",
		Image_DateCreated = "'	(Var:'svDateCreated')'"';
	
	Inline:
		-Database=$svDatabase,
		-Table=$svImagesTable,
		-Username=$svUsername,
		-Password=$svPassword,
		-SQL=$vSQLAddImage;
		// If there was an add error, kick out 5033 "Upload Failed" error
		// Otherwise output error 5061 "Upload Successful"
		If: (Error_CurrentError)!=(Error_NoError);
			Var:'vError'='5033';
		Else;
			Var:'vError' = '5061';
			Var:'vOption' = (#NewFileName);
		/If;
			If: $svDebug == 'Y';
				'<p class="debug">\n';
				'249: vError = ' $vError '<br>\r';
				'</p>\n';
			/If;
	/Inline;
?>
<table border="0" cellpadding="2" cellspacing="2" width="460">
	<tr>
		<td VALIGN="top">		
			<h2>Image Upload Report</h2>
[If: (Var:'vError') != '']
[Show_Error: -ErrNum=(Var:'vError'), -Option=(Var:'vOption'), -PosColor='0099FF', -NegColor='FF0000', -BgColor='CCCCCC']
[/If]
			<p><a href="[Response_Filepath]">Upload Additional Images</a></p>
			</td>
		</tr>
	</table>
[/If]
</p>
<?Lassoscript
If: $svDebug == 'Y';
	Include: ($svLibsPath) 'vardumpuniversal.lasso';
/If;
?>
</body>
</html>